﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIASchedulingService.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class LoginPatientSideToEcStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.ServiceAppointment.cvt_Type.Value)
            {
                return;
            }
            if (string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = "FAKE_PatientLogin";
                return;
            }
            var loginId = VistaMapperHelper.GetViaLoginId(state.PatLoginRequest, Side.Patient);
            
            //Set the Response into the Patient Side's Query Bean.Provider.UserId so that make appointment can succeed
            state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = loginId;
        }
    }
}
